<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Withdraw Funds</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f4efec;
        margin: 0;
        padding: 0;
    }

    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .nav-bar i {
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Container */
    .container {
        max-width: 500px;
        margin: 20px auto;
        padding: 15px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    /* Form */
    .form-group {
        margin-bottom: 15px;
    }
    label {
        font-size: 14px;
        font-weight: bold;
        display: block;
        margin-bottom: 5px;
    }
    input[type="number"],
    input[type="text"] {
        width: 100%;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #ccc;
    }

    /* Button */
    .btn {
        background: #092227;
        color: white;
        padding: 12px;
        width: 100%;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
    }
    .btn:hover {
        background: #0d3344;
    }
</style>
</head>
<body>

<!-- Header -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Withdraw Funds</div>
</div>

<!-- Content -->
<div class="container">
    <form action="<?php echo e(route('user.withdraw.request')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label>Withdraw Method</label>
            <input type="text" value="<?php echo e(user()->gateway_method); ?>" readonly>
        </div>

        <div class="form-group">
            <label>Withdraw Amount</label>
            <input type="number" name="amount" step="any" placeholder="Minimum: 35 | Maximum: 566" required>
        </div>

        <div class="form-group">
            <label>Withdraw Address</label>
            <input type="text" value="<?php echo e(user()->gateway_number); ?>" readonly>
        </div>

        <button type="submit" class="btn">Submit</button>
    </form>
</div>

<?php echo $__env->make('partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>
</html>
<?php /**PATH /home/mininggp/public_html/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>