<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Deposit Confirmation</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f4efec;
        margin: 0;
        padding: 0;
    }

    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .nav-bar i {
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Container */
    .container {
        max-width: 500px;
        margin: 20px auto;
        padding: 15px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    /* Recharge Info */
    .recharge-info {
        background: #092227;
        color: white;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
        text-align: center;
    }
    .recharge-label {
        font-size: 14px;
        margin: 0;
    }
    .recharge-amount {
        font-size: 24px;
        font-weight: bold;
        margin: 5px 0;
    }
    .recharge-method {
        font-size: 16px;
        margin: 5px 0;
    }
    .recharge-timer {
        font-size: 14px;
        margin-top: 10px;
    }

    /* Form */
    .input-label {
        font-size: 14px;
        font-weight: bold;
        margin-top: 12px;
        display: block;
    }
    input[type="text"], input[type="file"] {
        width: 100%;
        padding: 10px;
        margin-top: 5px;
        border-radius: 5px;
        border: 1px solid #ccc;
    }

    /* Copy Field */
    .copy-field {
        display: flex;
        margin-top: 5px;
    }
    .copy-field input {
        flex: 1;
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
    }
    .copy-field button {
        background: #092227;
        color: white;
        padding: 10px 15px;
        border: none;
        cursor: pointer;
        border-top-right-radius: 5px;
        border-bottom-right-radius: 5px;
    }
    .copy-field button:hover {
        background: #0d3344;
    }

    /* Submit Button */
    .submit-btn {
        background: #092227;
        color: white;
        padding: 12px;
        width: 100%;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        margin-top: 15px;
        cursor: pointer;
    }
    .submit-btn:hover {
        background: #0d3344;
    }
</style>
</head>
<body>

<!-- Header -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Deposit Confirmation</div>
</div>

<!-- Content -->
<div class="container">
    <div class="recharge-info">
        <p class="recharge-label">Requested Amount</p>
        <p class="recharge-amount"><?php echo e(price($amount)); ?></p>
        <p class="recharge-method"><?php echo e($payment_method->name); ?></p>
        <p class="recharge-timer"><span id="timer">30:00</span> remaining</p>
    </div>

    <form action="<?php echo e(route('payment_confirmation')); ?>" method="POST" enctype="multipart/form-data" class="recharge-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="amount" value="<?php echo e($amount); ?>">
        <input type="hidden" name="payment_method" value="<?php echo e($payment_method->name); ?>">

        <label class="input-label">Recharge Address</label>
        <div class="copy-field">
            <input type="text" value="<?php echo e($payment_method->address); ?>" id="myInput" readonly>
            <button type="button" id="myTooltip" onclick="copyToClipboard()">Copy</button>
        </div>

        <label class="input-label">Transaction ID</label>
        <input type="text" name="transaction_id" placeholder="Transaction ID" required>

        <label class="input-label">Upload Screenshot</label>
        <input type="file" name="photo" required>

        <button type="submit" class="submit-btn">Recharge</button>
    </form>
</div>

<script>
    // Copy to clipboard function
    function copyToClipboard() {
        var copyText = document.getElementById("myInput");
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(copyText.value);
        alert("Copied: " + copyText.value);
    }

    // Countdown timer
    let timerElement = document.getElementById("timer");
    let time = 30 * 60; // 30 minutes in seconds
    setInterval(() => {
        let minutes = Math.floor(time / 60);
        let seconds = time % 60;
        seconds = seconds < 10 ? "0" + seconds : seconds;
        timerElement.textContent = `${minutes}:${seconds}`;
        if (time > 0) {
            time--;
        }
    }, 1000);
</script>
<?php echo $__env->make('partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/merrille/web2.merrilledge.top/resources/views/app/main/deposit/recharge_confirm.blade.php ENDPATH**/ ?>