<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Deposit</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f4efec;
        margin: 0;
        padding: 0;
    }

    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .nav-bar i {
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Container */
    .container {
        max-width: 500px;
        margin: 20px auto;
        padding: 15px;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    /* Labels */
    .font-14 {
        font-size: 14px;
        font-weight: bold;
        margin-bottom: 6px;
    }

    /* Select */
    select {
        width: 100%;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #ccc;
        font-size: 14px;
    }

    /* Amount Boxes */
    .amount-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
        margin-top: 10px;
    }
    .amount-box {
        background: #092227;
        color: white;
        padding: 10px;
        text-align: center;
        border-radius: 5px;
        cursor: pointer;
        font-weight: bold;
    }
    .amount-box:hover {
        background: #0d3344;
    }

    /* Input */
    input[type="number"], input[name="getAmount"] {
        width: 100%;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #ccc;
        margin-top: 6px;
    }

    /* Button */
    .btn-submit {
        background: #092227;
        color: white;
        padding: 12px;
        width: 100%;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        margin-top: 15px;
        cursor: pointer;
    }
    .btn-submit:hover {
        background: #0d3344;
    }
</style>
</head>
<body>

<!-- Header -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Deposit</div>
</div>

<!-- Content -->
<div class="container">
    <form method="post">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="amount" value="">
        <input type="hidden" name="method">

        <div class="font-14">Choose Channel</div>
        <select name="methosd" id="methosd" required>
            <option value="">-- Select Payment Method --</option>
            <?php $__currentLoopData = \App\Models\PaymentMethod::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($element->id); ?>"><?php echo e($element->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <div class="font-14" style="margin-top:15px;">Choose Amount</div>
        <div class="amount-grid">
            <div class="amount-box" onclick="getAmount(this, 20)">20</div>
            <div class="amount-box" onclick="getAmount(this, 50)">50</div>
            <div class="amount-box" onclick="getAmount(this, 100)">100</div>
            <div class="amount-box" onclick="getAmount(this, 200)">200</div>
            <div class="amount-box" onclick="getAmount(this, 300)">300</div>
            <div class="amount-box" onclick="getAmount(this, 500)">500</div>
            <div class="amount-box" onclick="getAmount(this, 1000)">1000</div>
            <div class="amount-box" onclick="getAmount(this, 2000)">2000</div>
            <div class="amount-box" onclick="getAmount(this, 5000)">5000</div>
        </div>

        <div class="font-14" style="margin-top:15px;">Enter Amount</div>
        <input type="number" name="getAmount" placeholder="Enter custom amount">

        <button type="button" class="btn-submit" onclick="submitRecharge()">Go to Payment</button>
    </form>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('loading', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php if(session()->has('deposit_success')): ?>
    <script>
        openMessage('success', 'Success');
    </script>
<?php endif; ?>

<script>
    function getAmount(_this, amount) {
        document.querySelector('input[name="amount"]').value = amount;
        document.querySelector('input[name="getAmount"]').value = amount;
    }

    function submitRecharge() {
        document.querySelector('.loader').style.display = 'block';

        let amount = document.querySelector('input[name="getAmount"]').value;
        let methosd = document.querySelector('select[name="methosd"]').value;

        if (methosd === '') {
            document.querySelector('.loader').style.display = 'none';
            message('Choose Now');
            return;
        }

        if (amount >= 20) {
            window.location.href = '<?php echo e(url('/deposit')); ?>' + "/" + amount + "/" + methosd;
        } else {
            document.querySelector('.loader').style.display = 'none';
            message('Select Minimum Amount');
        }
    }
</script>
<?php echo $__env->make('partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/mininggp/public_html/resources/views/app/main/deposit/index.blade.php ENDPATH**/ ?>