<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rewards Center</title>
    <meta name="csrf-token" content="{{ csrf_token() }}"/>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f4efec;
            color: #092227;
        }
        .navboxi {
            background: #092227;
            color: white;
            padding: 10px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .van-nav-bar__left i {
            cursor: pointer;
        }
        .rightimg img {
            width: 25px;
            cursor: pointer;
        }
        .imgtaskio {
            width: 100%;
        }
        .friends, .cashi {
            text-align: center;
            margin: 10px 0;
        }
        .section-box {
            padding: 15px;
        }
        .listof {
            background: white;
            padding: 10px;
            margin: 5px;
            border-radius: 8px;
            text-align: center;
        }
        .btn {
            background: #092227;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            display: inline-block;
        }
        .btn:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        .amounti, .numberof {
            display: flex;
            gap: 10px;
            justify-content: center;
            flex-wrap: wrap;
        }
        .rebatei {
            font-weight: bold;
            margin-bottom: 5px;
        }
        .imgtask {
            width: 100%;
            margin-top: 10px;
        }
        .becomea {
            text-align: center;
            font-style: italic;
            color: #444;
        }
    </style>
</head>
<body>

<div id="app">
    <div class="taskbox">
        <!-- Navigation Bar -->
        <div class="van-nav-bar navboxi">
            <div class="van-nav-bar__left" onclick="window.location.href='{{route('dashboard')}}'">
                <i>&larr;</i>
            </div>
            <div class="van-nav-bar__title">Rewards Center</div>
        
        </div>

        <!-- Banner Image -->
        
        <p class="friends">Invite friends</p>
        <p class="cashi">Complete tasks and get cash rewards</p>

        <section class="section-box">
            <div class="listof">
                <p>Invite friends to register for {{price(setting('total_member_register_reword_amount'))}} each, 
                up to {{setting('total_member_register_reword')}} people</p>
            </div>

            <!-- Member Reward Section -->
            <div class="numberof">
                <?php $first_level_users = \App\Models\User::where('ref_by', auth()->user()->ref_id)->count(); ?>
                <div class="listof">
                    <p>{{$first_level_users}}/{{setting('total_member_register_reword')}}</p>
                    <span>Number of people</span>
                </div>
                <div class="listof">
                    <p>{{price(setting('total_member_register_reword_amount') * setting('total_member_register_reword'))}}</p>
                    <span>Reward amount</span>
                </div>
                <div class="listof">
                    <p id="reword_balance">{{price(auth()->user()->reword_balance)}}</p>
                    <span>Rewards available</span>
                </div>
            </div>

            <div style="text-align:center;margin-top:10px;">
                @if($first_level_users >= setting('total_member_register_reword'))
                    <button class="btn" onclick="ReadyReceivedForReword()">Receive</button>
                @else
                    <button class="btn" onclick="notReadyReceivedForReword()">Receive</button>
                @endif
            </div>

            <?php $rebate = \App\Models\Rebate::first(); ?>

            <!-- Interest Commission Section -->
            <div class="listof">
                <p class="rebatei">
                    Interest commission rebate, <span>{{$rebate->interest_commission1}}%</span> for level 1, 
                    <span>{{$rebate->interest_commission2}}%</span> for level 2, 
                    and <span>{{$rebate->interest_commission3}}%</span> for level 3
                </p>
                <div class="amounti">
                    <div class="listof">
                        <p id="interest_received">{{price(auth()->user()->interest_cumulative_balance_received)}}</p>
                        <span>Cumulative rewards</span>
                    </div>
                    <div class="listof">
                        <p id="interest_receive">{{price(auth()->user()->interest_cumulative_balance)}}</p>
                        <span>Rewards available</span>
                    </div>
                </div>
                <div style="text-align:center;">
                    <button class="btn" onclick="interestCommissionReceiver(this)" 
                    @if(auth()->user()->interest_cumulative_balance <= 0) disabled @endif>Receive</button>
                </div>
            </div>

            <!-- Team Commission Section -->
            <div class="listof">
                <p class="rebatei">
                    Invite users to invest in equipment rebates, 
                    <span>{{$rebate->team_commission1}}%</span> for level 1, 
                    <span>{{$rebate->team_commission2}}%</span> for level 2, 
                    and <span>{{$rebate->team_commission3}}%</span> for level 3
                </p>
                <div class="amounti">
                    <div class="listof">
                        <p id="cumulative_received">{{price(auth()->user()->invest_cumulative_balance_received)}}</p>
                        <span>Cumulative rewards</span>
                    </div>
                    <div class="listof">
                        <p id="cumulative_receive">{{price(auth()->user()->invest_cumulative_balance)}}</p>
                        <span>Rewards available</span>
                    </div>
                </div>
                <div style="text-align:center;">
                    <button class="btn" onclick="teamCommissionReceiver(this)" 
                    @if(auth()->user()->invest_cumulative_balance <= 0) disabled @endif>Receive</button>
                </div>
            </div>

        </section>
    </div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script>
function ReadyReceivedForReword(){
    $.ajaxSetup({ headers: { 'X-CSRF-Token' : $('meta[name=csrf-token]').attr('content') } });
    $.get('{{route('received.tareget.member.registered')}}', function(data){
        $('#reword_balance').text(data.reword);
        alert(data.message);
    });
}

function notReadyReceivedForReword(){
    alert('Not yet ready for received reward.');
}

function teamCommissionReceiver(btn){
    $.ajaxSetup({ headers: { 'X-CSRF-Token' : $('meta[name=csrf-token]').attr('content') } });
    $.get('{{route('received.invest.commission')}}', function(data){
        $('#cumulative_received').text(data.cumulative);
        $('#cumulative_receive').text(data.invest_balance);
        if (data.invest_balance <= 0) $(btn).prop('disabled', true);
        alert(data.message);
    });
}

function interestCommissionReceiver(btn){
    $.ajaxSetup({ headers: { 'X-CSRF-Token' : $('meta[name=csrf-token]').attr('content') } });
    $.get('{{route('received.interest.commission')}}', function(data){
        $('#interest_received').text(data.interest_received_balance);
        $('#interest_receive').text(data.interest_receive_balance);
        if (data.interest_receive_balance <= 0) $(btn).prop('disabled', true);
        alert(data.message);
    });
}
</script>
@include('partials.preloader')
</body>
</html>
