<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Claim Your Reward</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f4efec;
            color: #092227;
        }
        /* Responsive Header */
        .nav-bar {
            background: #092227;
            padding: 10px 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            color: white;
            flex-wrap: wrap;
        }
        .nav-left,
        .nav-right {
            display: flex;
            align-items: center;
            flex: 1;
            min-width: 80px;
        }
        .nav-left img {
            width: 28px;
            cursor: pointer;
        }
        .nav-title {
            flex: 2;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            line-height: 1.4;
        }
        .manage {
            font-size: 14px;
            background: rgba(255,255,255,0.15);
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            white-space: nowrap;
        }
        /* Mobile adjustments */
        @media (max-width: 500px) {
            .nav-title {
                font-size: 16px;
            }
            .manage {
                font-size: 12px;
                padding: 5px 10px;
            }
            .nav-left img {
                width: 24px;
            }
        }

        .content-wrap {
            padding: 20px;
            text-align: center;
        }
        .uni-input-wrapper {
            background: white;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 15px;
        }
        .uni-input-input {
            width: 100%;
            border: none;
            font-size: 16px;
            outline: none;
        }
        .exchange-btn {
            background: #092227;
            color: white;
            padding: 10px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
        }
        /* Overlay popup */
        .overlay {
            display: none;
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: rgba(0,0,0,0.6);
            z-index: 1000;
        }
        .ex {
            display: none;
            position: fixed;
            top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 15px;
            text-align: center;
            border-radius: 10px;
            width: 90%;
            max-width: 400px;
            z-index: 1001;
        }
        .ex img {
            width: 100%;
        }
        .ccon {
            margin-top: 10px;
            font-size: 20px;
            font-weight: bold;
        }
        .ttik {
            color: #092227;
            margin: 10px 0;
        }
        .takeIt {
            display: block;
            background: #092227;
            color: white;
            padding: 10px;
            border-radius: 5px;
            text-decoration: none;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<?php $bonus = \App\Models\Bonus::where('status', 'active')->first(); ?>

<!-- Overlay Popup -->
<div class="overlay" onclick="closePop()"></div>
<div class="ex">
    <img src="{{asset('public/ex.png')}}" alt="">
    <h3 class="ccon">Congratulations</h3>
    <h3 class="ttik">{{price(1) .' - '. price($bonus ? $bonus->amount : 1)}}</h3>
    <a href="javascript:void(0)" class="takeIt" onclick="getClaiemCode()">Happy to Take It</a>
</div>

<!-- Navigation Bar -->
<div class="nav-bar">
    <div class="nav-left" onclick="window.location.href='{{route('profile')}}'">
        <img src="{{asset('public/cliem')}}/btn_navigationbar_back_light.png" alt="Back">
    </div>
    <div class="nav-title">Claim your reward</div>
    <div class="nav-right">
        <div class="manage" onclick="window.location.href='{{route('climRecord')}}'">Record</div>
    </div>
</div>

<!-- Input and Button -->
<div class="content-wrap">
    <div class="uni-input-wrapper">
        <input maxlength="140" placeholder="Please enter the redemption code…" name="client" class="uni-input-input">
    </div>
    <div class="exchange-btn" onclick="toClient()">Click Claim</div>
</div>

<input type="hidden" name="csrf-token" value="{{csrf_token()}}">

<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script>
    function closePop(){
        document.querySelector('.overlay').style.display = 'none';
        document.querySelector('.ex').style.display = 'none';
    }

    function toClient(){
        let cliem = document.querySelector('input[name="client"]').value;
        if (cliem == ''){
            alert('Input Claim Code');
            document.querySelector('input[name="client"]').value = '';
            return;
        }

        $.get('{{url('submit-bonus-check')}}'+'/'+cliem, function(data){
            if (data.status === true){
                document.querySelector('.overlay').style.display = 'block';
                document.querySelector('.ex').style.display = 'block';
            } else {
                alert(data.message);
                document.querySelector('input[name="client"]').value = '';
            }
        });
    }

    function getClaiemCode(){
        let cliem = document.querySelector('input[name="client"]').value;
        document.querySelector('.takeIt').innerHTML = 'Loading...';

        $.get('{{url('submit-bonus-amount')}}'+'/'+cliem, function(data){
            alert(data.message);
            document.querySelector('.takeIt').innerHTML = 'Happy to Take It';
            closePop();
            document.querySelector('input[name="client"]').value = '';
        });
    }
</script>

</body>
</html>
