<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Bind Bank Account</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f4efec; /* Theme background */
        margin: 0;
        padding: 0;
    }

    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .nav-bar i {
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Form Container */
    .form-container {
        padding: 15px;
        background: white;
        max-width: 400px;
        margin: 20px auto;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .form-container span {
        display: block;
        margin: 8px 0 4px;
        font-weight: bold;
    }
    .form-container input, 
    .form-container select {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        outline: none;
        font-size: 14px;
        margin-bottom: 15px;
    }
    .form-container select {
        background: #092227;
        color: white;
    }
    .form-container img {
        height: 14px;
        vertical-align: middle;
        margin-right: 6px;
    }

    /* Button */
    .btn-submit {
        background: #092227;
        color: white;
        padding: 12px;
        width: 100%;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
    }
    .btn-submit:hover {
        background: #0d3344;
    }
</style>
</head>
<body>

<!-- Navigation -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Bind Bank Account</div>
</div>
@php
    $user = auth()->user();
@endphp
<!-- Form -->
<div class="form-container">
    <form action="{{route('setup.gateway.submit')}}" method="post">
        @csrf

        <span>* Account Name</span>
        <input autocomplete="off" type="text" id="bank_name" name="realname" value="{{ $user->realname }}" placeholder="Enter your Account Name" required>

        <span>* Bank Name</span>
        <select name="gateway_method" required>@php
    $user = auth()->user();
@endphp
            @foreach(\App\Models\BankList::where('status', '1')->get() as $elemenet)
                                        <option value="{{$elemenet->bank_code}}" @if($user->gateway_method == $elemenet->bank_code) selected @endif>{{$elemenet->name}}</option>
                                      @endforeach
        </select>

        <span>* Account Number</span>
        <input autocomplete="off" type="number" name="gateway_address" value="{{ $user->gateway_address }}" placeholder="Enter your Account Number" required>

        <button type="submit" class="btn-submit">Submit</button>
    </form>
</div> 
@include('alert-message')
@include('partials.preloader')
</body>
</html>
