<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f4efec;
            color: #092227;
        }
        /* Header */
        .nav-bar {
            background: #092227;
            color: white;
            display: flex;
            align-items: center;
            padding: 12px 15px;
        }
        .nav-bar svg {
            width: 24px;
            height: 24px;
            cursor: pointer;
            margin-right: 10px;
            fill: white;
        }
        .nav-bar-title {
            flex: 1;
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin-right: 34px;
        }
        /* About section */
        .about-container {
            max-width: 900px;
            margin: auto;
            padding: 20px;
            line-height: 1.6;
        }
        h2 {
            color: #092227;
            text-align: center;
            margin-bottom: 15px;
        }
        p {
            margin-bottom: 15px;
        }
        /* Contact links */
        .contact-links {
            margin-top: 30px;
            text-align: center;
        }
        .contact-links a {
            display: inline-flex;
            align-items: center;
            margin: 10px;
            text-decoration: none;
            color: white;
            background: #092227;
            padding: 10px 15px;
            border-radius: 5px;
            font-size: 14px;
        }
        .contact-links svg {
            width: 20px;
            height: 20px;
            margin-right: 6px;
            fill: white;
        }
        /* Mobile adjustments */
        @media (max-width: 600px) {
            .nav-bar-title {
                font-size: 18px;
                margin-right: 28px;
            }
            .contact-links a {
                font-size: 13px;
                padding: 8px 12px;
            }
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="nav-bar">
    <svg onclick="window.history.back();" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
        <path d="M15.41 7.41 14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
    </svg>
    <div class="nav-bar-title">About Us</div>
</div>

<!-- About Section -->
<div class="about-container">
    <h2>Welcome to Our Platform</h2>
    <p>
        We are committed to providing a seamless and rewarding experience for our users. 
        Our platform is built with security, speed, and transparency in mind, 
        ensuring that every interaction you have is safe and enjoyable.
    </p>
    <p>
        Whether you're here to claim bonuses, make withdrawals, or simply enjoy our services, 
        we strive to deliver excellence every step of the way. 
        Our team is dedicated to innovation and continuous improvement, 
        bringing you new features and updates regularly.
    </p>
    <p>
        Thank you for being part of our growing community. 
        We look forward to serving you and helping you achieve your goals.
    </p>

    <!-- Contact Links -->
    <div class="contact-links">
        <a href="https://t.me/JayDinTech" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 240 240">
                <path d="M120,0C53.73,0,0,53.73,0,120s53.73,120,120,120,120-53.73,120-120S186.27,0,120,0Zm57.68,82.33-21.6,101.93c-1.63,7.45-6.07,9.28-12.27,5.78l-33.87-25-16.34,15.76c-1.81,1.81-3.33,3.33-6.84,3.33l2.45-34.79,63.32-57.19c2.75-2.45-.6-3.81-4.27-1.36l-78.17,49.13-33.66-10.51c-7.32-2.29-7.45-7.32,1.52-10.81l131.29-50.67C172.67,74.26,178.05,77.09,177.68,82.33Z"/>
            </svg>
            Telegram
        </a>
        <a href="https://t.me/JayDinTech" target="_blank">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                <path d="M380.9 97.1C339-3.9 264.4-33.5 187.5 2.4 110.6 38.3 63 113.5 63 197.4c0 34.7 9.1 68.7 26.4 98.1l-27.9 102.4 105.3-27.7c28.5 15.6 60.3 23.8 92.8 23.8 83.9 0 159.1-47.6 195-124.5 35.9-76.9 19.8-167.7-41.7-232.4zM224 370.6c-27.1 0-53.7-7.3-76.9-21.1l-5.5-3.3-62.5 16.4 16.7-61-3.6-5.8c-16.3-26.5-24.9-57.2-24.9-88.5 0-91.4 74.3-165.7 165.7-165.7 44.3 0 85.9 17.3 117.2 48.6 31.3 31.3 48.6 72.9 48.6 117.2 0 91.4-74.3 165.7-165.7 165.7z"/>
            </svg>
            WhatsApp
        </a>
    </div>
</div>

</body>
</html>
