<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Change Password</title>
<style>
    body { 
        font-family: Arial, sans-serif; 
        background: #f4efec; /* Light background */
        margin: 0; 
        padding: 0; 
    }

    /* Nav Bar */
    .nav-bar { 
        background: #092227; /* New header color */
        color: white; 
        padding: 12px; 
        display: flex; 
        align-items: center; 
    }
    .nav-bar i { 
        cursor: pointer; 
        margin-right: 10px; 
    }
    .nav-title { 
        font-size: 18px; 
        font-weight: bold; 
    }

    /* Tabs */
    .tabs { 
        display: flex; 
        border-bottom: 2px solid #ddd; 
        margin-top: 10px; 
    }
    .tab { 
        flex: 1; 
        text-align: center; 
        padding: 10px; 
        cursor: pointer; 
        background: #eee; 
        border-bottom: 2px solid transparent; 
    }
    .tab.active { 
        background: white; 
        border-bottom: 2px solid #092227; /* Match theme */
        font-weight: bold; 
    }

    /* Form Section */
    .form-container { 
        padding: 15px; 
        background: white; 
        max-width: 400px; 
        margin: 20px auto; 
        border-radius: 8px; 
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); 
    }
    .form-container p { 
        margin: 8px 0 4px; 
        font-weight: bold; 
    }
    .input-box { 
        position: relative; 
        margin-bottom: 15px; 
    }
    .input-box input { 
        width: 100%; 
        padding: 10px; 
        border: 1px solid #ccc; 
        border-radius: 5px; 
        outline: none; 
        font-size: 14px; 
    }
    .input-box img { 
        position: absolute; 
        right: 10px; 
        top: 50%; 
        transform: translateY(-50%); 
        height: 20px; 
        cursor: pointer; 
    }

    /* Button */
    .btn-confirm { 
        background: #092227; /* Theme button color */
        color: white; 
        padding: 12px; 
        width: 100%; 
        border: none; 
        border-radius: 5px; 
        font-size: 16px; 
        cursor: pointer; 
    }
    .btn-confirm:hover { 
        background: #0d3344; /* Slightly lighter hover */
    }
</style>
</head>
<body>

<!-- Navigation -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Change Password</div>
</div>



   <form class="form-container" action="{{route('user.change.password.confirmation')}}" method="post">
                    @csrf
<!-- Form -->

    <p>Old Password</p>
    <div class="input-box">
        <input type="password" name="old_password" placeholder="Please enter old password" required>

    </div>

    <p>New Password</p>
    <div class="input-box">
        <input type="password" name="new_password" placeholder="Please enter new password" required>

    </div>

    <p>Confirm Password</p>
    <div class="input-box">
        <input type="password" name="confirm_password" placeholder="Please re-enter new password" required>
    
    </div>

    <button type="submit" class="btn-confirm">Confirm</button>
</form>
@include('partials.preloader')
</body>
</html>
