@extends('admin.partials.master')

@section('admin_content')
<style>
    label {
        text-transform: unset;
    }
</style>

<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-12">
            <form action="{{ route('admin.setting.insert') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ $data ? $data->id : '' }}">

                
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            {{ $data ? 'Update' : 'Create New' }} Settings
                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="row">

                        
                            <div class="col-sm-6 mt-2">
                                <label for="withdraw_charge">Withdraw Charge (%)</label>
                                <input type="number" class="form-control @error('withdraw_charge') is-invalid @else is-valid @enderror"
                                    name="withdraw_charge" id="withdraw_charge" placeholder="Withdraw charge"
                                    value="{{ old('withdraw_charge', $data->withdraw_charge ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                                @error('withdraw_charge')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            
                            <div class="col-sm-6 mt-2">
                                <label for="minimum_withdraw">Minimum Withdraw</label>
                                <input type="number" class="form-control @error('minimum_withdraw') is-invalid @else is-valid @enderror"
                                    name="minimum_withdraw" id="minimum_withdraw" placeholder="Minimum Withdraw"
                                    value="{{ old('minimum_withdraw', $data->minimum_withdraw ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                                @error('minimum_withdraw')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                        
                            <div class="col-sm-6 mt-2">
                                <label for="maximum_withdraw">Maximum Withdraw</label>
                                <input type="number" class="form-control @error('maximum_withdraw') is-invalid @else is-valid @enderror"
                                    name="maximum_withdraw" id="maximum_withdraw" placeholder="Maximum Withdraw"
                                    value="{{ old('maximum_withdraw', $data->maximum_withdraw ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                                @error('maximum_withdraw')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            
                            <div class="col-sm-6 mt-2">
                                <label for="w_time_status">Withdraw Switch</label>
                                <select class="form-control" name="w_time_status" id="w_time_status" required>
                                    <option value="active" {{ $data && $data->w_time_status == 'active' ? 'selected' : '' }}>START</option>
                                    <option value="inactive" {{ $data && $data->w_time_status == 'inactive' ? 'selected' : '' }}>OFF</option>
                                </select>
                                <div class="valid-feedback">Note: This field is required</div>
                            </div>

                    
                            <div class="col-sm-6 mt-2">
                                <label for="checkin">Daily Checkin Amount</label>
                                <input type="number" class="form-control is-valid"
                                    name="checkin" id="checkin" placeholder="Daily Checkin"
                                    value="{{ old('checkin', $data->checkin ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                            </div>

                            
                            <div class="col-sm-6 mt-2">
                                <label for="registration_bonus">Registration Bonus</label>
                                <input type="number" class="form-control is-valid"
                                    name="registration_bonus" id="registration_bonus" placeholder="Registration Bonus"
                                    value="{{ old('registration_bonus', $data->registration_bonus ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                            </div>

                    
                            <div class="col-sm-6 mt-2">
                                <label for="telegram">Telegram</label>
                                <input type="text" class="form-control is-valid"
                                    name="telegram" id="telegram" placeholder="Telegram link"
                                    value="{{ old('telegram', $data->telegram ?? '') }}">
                                <div class="valid-feedback">Note: This field is optional</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="card-title">Deposit & Payout Settings</h5>
                    </div>
                    <div class="card-body row">

                        <div class="form-group col-sm-6 mt-2">
                            <label for="open_deposit">Open Deposit</label>
                            <select name="open_deposit" class="form-control form-control-lg">
                                <option value="1" {{ $data && $data->open_deposit == 1 ? 'selected' : '' }}>Yes</option>
                                <option value="0" {{ $data && $data->open_deposit == 0 ? 'selected' : '' }}>No</option>
                            </select>
                        </div>

                        <div class="form-group col-sm-6 mt-2">
                            <label for="open_transfer">Open Payout</label>
                            <select name="open_transfer" class="form-control form-control-lg">
                                <option value="1" {{ $data && $data->open_transfer == 1 ? 'selected' : '' }}>Yes</option>
                                <option value="0" {{ $data && $data->open_transfer == 0 ? 'selected' : '' }}>No</option>
                            </select>
                        </div>

                        <div class="form-group col-sm-6 mt-2">
                            <label for="auto_deposit">Auto Deposit</label>
                            <select name="auto_deposit" class="form-control form-control-lg">
                                <option value="1" {{ $data && $data->auto_deposit == 1 ? 'selected' : '' }}>Enabled</option>
                                <option value="0" {{ $data && $data->auto_deposit == 0 ? 'selected' : '' }}>Disabled</option>
                            </select>
                        </div>

                        <div class="form-group col-sm-6 mt-2">
                            <label for="auto_transfer">Auto Payout</label>
                            <select name="auto_transfer" class="form-control form-control-lg">
                                <option value="1" {{ $data && $data->auto_transfer == 1 ? 'selected' : '' }}>Enabled</option>
                                <option value="0" {{ $data && $data->auto_transfer == 0 ? 'selected' : '' }}>Disabled</option>
                            </select>
                        </div>

                        <div class="form-group col-sm-6 mt-2">
                            <label for="auto_transfer_default">Auto Default Payout Method</label>
                            <select name="auto_transfer_default" class="form-control is-valid" required>
                                @foreach($paymentMethod as $method)
                                    <option value="{{ $method['tag'] }}" {{ $data && $data->auto_transfer_default == $method['tag'] ? 'selected' : '' }}>
                                        {{ $method['name'] }}
                                    </option>
                                @endforeach
                            </select>
                            <div class="valid-feedback">Note: This field is required</div>
                        </div>

                    </div>
                </div>
                <div class="card mt-3">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Submit Your Setting Information</h6>
                            <button type="submit" class="btn btn-success">
                                <i class="bx bx-plus"></i> {{ $data ? 'Update' : 'Submit' }}
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<script>
    function showPreview(event) {
        if (event.target.files.length > 0) {
            let src = URL.createObjectURL(event.target.files[0]);
            let preview = document.getElementById("file-ip-1-preview");
            preview.src = src;
            preview.style.display = "block";
        }
    }

    function showPreviewFavicon(event) {
        if (event.target.files.length > 0) {
            let src = URL.createObjectURL(event.target.files[0]);
            let preview = document.getElementById("favicon");
            preview.src = src;
            preview.style.display = "block";
        }
    }
</script>
@endsection
